drop table if exists pbe_prueba_empleado;

/*==============================================================*/
/* Table: pbe_prueba_empleado                                   */
/*==============================================================*/
create table pbe_prueba_empleado
(
   pbe_id               int not null auto_increment comment 'Llave primaria de pruebas al empleado',
   pbe_id_emp           int(11) not null comment 'Id de Empleado',
   pbe_id_tib           int not null comment 'Llave primaria - tipo de prueba',
   pbe_fecha            datetime not null comment 'Fecha de la prueba',
   pbe_persona_califica varchar(300) comment 'Persona que califico la prueba',
   pbe_lugar            varchar(300) comment 'Lugar de realización',
   pbe_resultado        varchar(300) comment 'ponderación/calificación/resultado',
   pbe_descripcion      varchar(1000) comment 'Descripción',
   pbe_estado           int not null comment 'Estado de registro (1=activo, 0=inactivo)',
   pbe_usu_creacion     int not null comment 'auditoria',
   pbe_fecha_creacion   datetime not null comment 'auditoria',
   pbe_usu_modificacion int not null comment 'auditoria',
   pbe_fecha_modificacion datetime not null comment 'auditoria',
   primary key (pbe_id)
);

alter table pbe_prueba_empleado comment 'Pruebas realizadas al empleado';

alter table pbe_prueba_empleado add constraint fk_pbe_id_emp foreign key (pbe_id_emp)
      references emp_empleado (emp_id) on delete restrict on update restrict;

alter table pbe_prueba_empleado add constraint fk_pbe_id_tib foreign key (pbe_id_tib)
      references tib_tipo_prueba (tib_id) on delete restrict on update restrict;

drop table if exists pse_pruebas_solicitante_empleo;

/*==============================================================*/
/* Table: pse_pruebas_solicitante_empleo                        */
/*==============================================================*/
create table pse_pruebas_solicitante_empleo
(
   pse_id               int not null auto_increment comment 'Llave primaria de pruebas al solicitante de empleo',
   pse_id_sle           int(11) not null comment 'Llave principal de Solicitante Empleo',
   pse_id_tib           int not null comment 'Llave primaria - tipo de prueba',
   pse_fecha            datetime not null comment 'Fecha de la prueba',
   pse_persona_califica varchar(300) comment 'Persona que califico la prueba',
   pse_lugar            varchar(300) comment 'Lugar de realización',
   pse_resultado        varchar(300) comment 'ponderación/calificación/resultado',
   pse_descripcion      varchar(1000) comment 'Descripción',
   pse_estado           int not null comment 'Estado de registro (1=activo, 0=inactivo)',
   pse_usu_creacion     int not null comment 'auditoria',
   pse_fecha_creacion   datetime not null comment 'auditoria',
   pse_usu_modificacion int not null comment 'auditoria',
   pse_fecha_modificacion datetime not null comment 'auditoria',
   primary key (pse_id)
);

alter table pse_pruebas_solicitante_empleo comment 'Pruebas realizadas al solicitante de empleo';

alter table pse_pruebas_solicitante_empleo add constraint fk_pse_id_sle foreign key (pse_id_sle)
      references sle_solicitante_empleo (sle_id) on delete restrict on update restrict;

alter table pse_pruebas_solicitante_empleo add constraint fk_pse_id_tib foreign key (pse_id_tib)
      references tib_tipo_prueba (tib_id) on delete restrict on update restrict;